#include <a_samp>
#include <a_sampdb>
#include <sscanf2>

#define D_INV          200
#define MAX_ITEMS      54
#define ALL_ITEMS_SIZE 30
#define MAX_OBJECT     1000

new PlayerText:Inventory[55][MAX_PLAYERS];
new Text:Button[8];
new DB:s_db;
new DBResult:s_res;

enum PlayerInv
{
	invName[MAX_PLAYER_NAME],
	invSlot[MAX_ITEMS],
	invKol[MAX_ITEMS],
};
new InventoryPlayer[MAX_PLAYERS][PlayerInv];

enum invPlayer
{
	invName[50],
    invSize,
    invObject,
    invText[200],
};
new Items_All[ALL_ITEMS_SIZE][invPlayer] = {
    {"",0,19461,""},
	{"  ",1,333,"    ,       "},
	{" ",2,334," ,   -"},
	{" ",3,335," ,   "},
	{" ",4,336,"    "},
	{" ",5,337,"   -  "},
	{"",6,339,""},
	{" ",7,325,"      "},
	{" 9",8,346,"    "},
	{" 9 (   )",9,347,",     "},
	{" ",10,348,",     "},
	{" 'Shotgun'",11,349,""},
	{" 'Combat Shotgun'",12,351,""},
	{" -  'Micro UZI'",13,352,""},
	{" -  'MP5'",14,353,""},
	{" -  'Tec 9'",15,372,""},
	{"  'AK-47'",16,355,""},
	{"  'M4'",17,356,""},
	{" ",18,357,""},
	{"  (   )",19,358,""},
	{"",20,371,""},
	{"  ",21,365,""},
	{"",22,366,""},
	{"-",23,367,""},
	{"",24,1242,""},
	{"  ",25,1279,""},
	{"",26,2704,""},
	{"  ",27,2814,""},
	{"",28,2769,""},
	{"",29,2768,""}
};

enum ObjInv
{
	obiDrop[2],
	Float:obiDropPos[3],
	obiObject,
};
new ObjectInv[MAX_OBJECT][ObjInv];


public OnFilterScriptInit()
{
    s_db = db_open("inventory.db");

    Button[0] = TextDrawCreate(445.000000, 246.000000, "_");
    TextDrawAlignment(Button[0], 2);
    TextDrawBackgroundColor(Button[0], 255);
    TextDrawFont(Button[0], 1);
    TextDrawLetterSize(Button[0], 0.500000, 1.000000);
    TextDrawColor(Button[0], -1);
    TextDrawSetOutline(Button[0], 0);
    TextDrawSetProportional(Button[0], 1);
    TextDrawSetShadow(Button[0], 1);
    TextDrawUseBox(Button[0], 1);
    TextDrawBoxColor(Button[0], 80);
    TextDrawTextSize(Button[0], 0.000000, -46.000000);
    TextDrawSetSelectable(Button[0], 0);

    Button[1] = TextDrawCreate(445.000000, 262.000000, "_");
    TextDrawAlignment(Button[1], 2);
    TextDrawBackgroundColor(Button[1], 255);
    TextDrawFont(Button[1], 1);
    TextDrawLetterSize(Button[1], 0.500000, 1.000000);
    TextDrawColor(Button[1], -1);
    TextDrawSetOutline(Button[1], 0);
    TextDrawSetProportional(Button[1], 1);
    TextDrawSetShadow(Button[1], 1);
    TextDrawUseBox(Button[1], 1);
    TextDrawBoxColor(Button[1], 80);
    TextDrawTextSize(Button[1], 0.000000, -46.000000);
    TextDrawSetSelectable(Button[1], 0);

    Button[2] = TextDrawCreate(445.000000, 278.000000, "_");
    TextDrawAlignment(Button[2], 2);
    TextDrawBackgroundColor(Button[2], 255);
    TextDrawFont(Button[2], 1);
    TextDrawLetterSize(Button[2], 0.500000, 1.000000);
    TextDrawColor(Button[2], -1);
    TextDrawSetOutline(Button[2], 0);
    TextDrawSetProportional(Button[2], 1);
    TextDrawSetShadow(Button[2], 1);
    TextDrawUseBox(Button[2], 1);
    TextDrawBoxColor(Button[2], 80);
    TextDrawTextSize(Button[2], 0.000000, -46.000000);
    TextDrawSetSelectable(Button[2], 0);

    Button[3] = TextDrawCreate(428.000000, 243.000000, "GIVE");
    TextDrawBackgroundColor(Button[3], 255);
    TextDrawFont(Button[3], 1);
    TextDrawLetterSize(Button[3], 0.500000, 1.500000);
    TextDrawColor(Button[3], -1);
    TextDrawSetOutline(Button[3], 0);
    TextDrawSetProportional(Button[3], 1);
    TextDrawSetShadow(Button[3], 0);
    TextDrawSetSelectable(Button[3], 1);

    Button[4] = TextDrawCreate(445.000000, 259.000000, "USE");
    TextDrawAlignment(Button[4], 2);
    TextDrawBackgroundColor(Button[4], 255);
    TextDrawFont(Button[4], 1);
    TextDrawLetterSize(Button[4], 0.500000, 1.500000);
    TextDrawColor(Button[4], -1);
    TextDrawSetOutline(Button[4], 0);
    TextDrawSetProportional(Button[4], 1);
    TextDrawSetShadow(Button[4], 0);
    TextDrawSetSelectable(Button[4], 1);

    Button[5] = TextDrawCreate(445.000000, 275.000000, "DROP");
    TextDrawAlignment(Button[5], 2);
    TextDrawBackgroundColor(Button[5], 255);
    TextDrawFont(Button[5], 1);
    TextDrawLetterSize(Button[5], 0.500000, 1.500000);
    TextDrawColor(Button[5], -1);
    TextDrawSetOutline(Button[5], 0);
    TextDrawSetProportional(Button[5], 1);
    TextDrawSetShadow(Button[5], 0);
    TextDrawSetSelectable(Button[5], 1);

    Button[6] = TextDrawCreate(445.000000, 294.000000, "_");
    TextDrawAlignment(Button[6], 2);
    TextDrawBackgroundColor(Button[6], 255);
    TextDrawFont(Button[6], 1);
    TextDrawLetterSize(Button[6], 0.500000, 1.000000);
    TextDrawColor(Button[6], -1);
    TextDrawSetOutline(Button[6], 0);
    TextDrawSetProportional(Button[6], 1);
    TextDrawSetShadow(Button[6], 1);
    TextDrawUseBox(Button[6], 1);
    TextDrawBoxColor(Button[6], 80);
    TextDrawTextSize(Button[6], 0.000000, -46.000000);
    TextDrawSetSelectable(Button[6], 0);

    Button[7] = TextDrawCreate(445.000000, 291.000000, "INFO");
    TextDrawAlignment(Button[7], 2);
    TextDrawBackgroundColor(Button[7], 255);
    TextDrawFont(Button[7], 1);
    TextDrawLetterSize(Button[7], 0.500000, 1.500000);
    TextDrawColor(Button[7], -1);
    TextDrawSetOutline(Button[7], 0);
    TextDrawSetProportional(Button[7], 1);
    TextDrawSetShadow(Button[7], 0);
    TextDrawSetSelectable(Button[7], 1);
    return 1;
}

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	if(newkeys == KEY_WALK)
	{
	    for(new i = 0; i < sizeof(ObjectInv); i++)
        {
            if (IsPlayerInRangeOfPoint(playerid, 2.0,ObjectInv[i][obiDropPos][0],ObjectInv[i][obiDropPos][1],ObjectInv[i][obiDropPos][2]))
            {
                DestroyObject(ObjectInv[i][obiObject]);
                GiveInventory(playerid, ObjectInv[i][obiDrop][0], ObjectInv[i][obiDrop][1]);
                ObjectInv[i][obiDrop][0] = 0;
	            ObjectInv[i][obiDrop][1] = 0;
	            ObjectInv[i][obiDropPos][0] = 0.0;
	            ObjectInv[i][obiDropPos][1] = 0.0;
	            ObjectInv[i][obiDropPos][2] = 0.0;
		        return 1;
            }
        }
	}
	if(newkeys == KEY_YES)
	{
        SelectTextDraw(playerid,0xddddddff);
        OpenInventory(playerid);
	}
	if(newkeys == KEY_NO) { for(new i; i < 46; i++) PlayerTextDrawHide(playerid,Inventory[i][playerid]); PlayerTextDrawHide(playerid,Inventory[53][playerid]); for(new i; i < 9; i++) TextDrawHideForPlayer(playerid,Button[i]); }
	return 1;
}

public OnPlayerSpawn(playerid)
{
    PlayerTextDrawShow(playerid,Inventory[46][playerid]),PlayerTextDrawShow(playerid,Inventory[47][playerid]),
    PlayerTextDrawShow(playerid,Inventory[48][playerid]),PlayerTextDrawShow(playerid,Inventory[49][playerid]),
    PlayerTextDrawShow(playerid,Inventory[50][playerid]),PlayerTextDrawShow(playerid,Inventory[51][playerid]),
    PlayerTextDrawShow(playerid,Inventory[52][playerid]);
	return 1;
}

public OnPlayerClickPlayerTextDraw(playerid, PlayerText:playertextid)
{
	for(new i; i < 53; i++)
	{
        if(playertextid == Inventory[i][playerid])
        {
			if(GetPVarInt(playerid,"ChangeSlot") == 0)
			{
                SetPVarInt(playerid,"SelectSlot",i);
                if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] == 0) { }
				else
				{
                    SetPVarInt(playerid,"ChangeSlot",GetPVarInt(playerid,"SelectSlot"));
				    PlayerTextDrawBackgroundColor(playerid,Inventory[GetPVarInt(playerid,"ChangeSlot")][playerid], -65281);
				    PlayerTextDrawShow(playerid,Inventory[GetPVarInt(playerid,"ChangeSlot")][playerid]);
				}
			}
			else if(GetPVarInt(playerid,"ChangeSlot") != 0)
			{
                SetPVarInt(playerid,"SelectSlot",i);
                PlayerTextDrawBackgroundColor(playerid,Inventory[GetPVarInt(playerid,"ChangeSlot")][playerid], -86);
                PlayerTextDrawShow(playerid,Inventory[GetPVarInt(playerid,"ChangeSlot")][playerid]);
                UpdateInventory(playerid);
                ObjInventory(playerid);
                SetPVarInt(playerid,"ChangeSlot",0);
                SetPVarInt(playerid,"SelectSlot",0);
                return 1;
			}
        }
    }
    return 1;
}

public OnDialogResponse(playerid, dialogid, response, listitem, inputtext[])
{
	switch(dialogid)
	{
	    case D_INV:
		{
            if(!response) return 1;
            new player,kol;
            if(sscanf(inputtext,"p<->ii",player,kol)) return ShowPlayerDialog(playerid,D_INV,1,"","{ffffff} ID    - - ,   !","","");
            else
			{
				if(InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] < kol) return ShowPlayerDialog(playerid,D_INV,1,"","    , !\n\n{ffffff} ID    - - ,   !","","");
				GiveInventory(player, InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1], InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1]);
				InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] = 0;
				InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] = 0;
				OpenInventory(playerid);
				OpenInventory(player);
			}
		}
	}
	return 1;
}

public OnPlayerClickTextDraw(playerid, Text:clickedid)
{
    if(clickedid == Button[3]) // give
    {
		if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] == 0 && InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] == 0) return 1;
		ShowPlayerDialog(playerid,D_INV,1,"","{ffffff} ID    - - ,   !","","");
    }
    if(clickedid == Button[4]) // use
    {
        if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] == 0 && InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] == 0) return 1;
        if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] != 0 && InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] != 0)
        {
            if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] == 29)
            {
				//       29,  
            }
        }
    }
    if(clickedid == Button[5]) // drop
    {
        if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] == 0 && InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] == 0) return 1;
        DropInventory(playerid);
    }
    if(clickedid == Button[7]) // info
    {
        if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] == 0 && InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] == 0) return 1;
        new string[200];
		format(string,sizeof(string),"{ffffff}: {32CD32}%s{ffffff}\n: {32CD32}%s{ffffff}\n (  ): {32CD32}%d",Items_All[InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1]][invName],Items_All[InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1]][invText],InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1]);
        ShowPlayerDialog(playerid,999,0,"",string,"","");
    }
    return 1;
}

public OnPlayerConnect(playerid)
{
Inventory[0][playerid] = CreatePlayerTextDraw(playerid,553.500000, 246.000000, "_");
PlayerTextDrawAlignment(playerid,Inventory[0][playerid], 2);
PlayerTextDrawBackgroundColor(playerid,Inventory[0][playerid], 255);
PlayerTextDrawFont(playerid,Inventory[0][playerid], 1);
PlayerTextDrawLetterSize(playerid,Inventory[0][playerid], 0.500000, 22.000001);
PlayerTextDrawColor(playerid,Inventory[0][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[0][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[0][playerid], 1);
PlayerTextDrawSetShadow(playerid,Inventory[0][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[0][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[0][playerid], 80);
PlayerTextDrawTextSize(playerid,Inventory[0][playerid], 0.000000, -175.000000);
PlayerTextDrawSetSelectable(playerid,Inventory[0][playerid], 0);

Inventory[1][playerid] = CreatePlayerTextDraw(playerid,470.000000, 246.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[1][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[1][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[1][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[1][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[1][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[1][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[1][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[1][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[1][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[1][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[1][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[1][playerid], 1);

Inventory[2][playerid] = CreatePlayerTextDraw(playerid,498.000000, 246.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[2][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[2][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[2][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[2][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[2][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[2][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[2][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[2][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[2][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[2][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[2][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[2][playerid], 1);

Inventory[3][playerid] = CreatePlayerTextDraw(playerid,526.000000, 246.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[3][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[3][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[3][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[3][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[3][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[3][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[3][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[3][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[3][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[3][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[3][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[3][playerid], 1);

Inventory[4][playerid] = CreatePlayerTextDraw(playerid,554.000000, 246.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[4][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[4][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[4][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[4][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[4][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[4][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[4][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[4][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[4][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[4][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[4][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[4][playerid], 1);

Inventory[5][playerid] = CreatePlayerTextDraw(playerid,582.000000, 246.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[5][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[5][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[5][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[5][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[5][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[5][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[5][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[5][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[5][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[5][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[5][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[5][playerid], 1);

Inventory[6][playerid] = CreatePlayerTextDraw(playerid,610.000000, 246.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[6][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[6][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[6][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[6][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[6][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[6][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[6][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[6][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[6][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[6][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[6][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[6][playerid], 1);

Inventory[7][playerid] = CreatePlayerTextDraw(playerid,470.000000, 279.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[7][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[7][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[7][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[7][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[7][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[7][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[7][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[7][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[7][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[7][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[7][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[7][playerid], 1);

Inventory[8][playerid] = CreatePlayerTextDraw(playerid,498.000000, 279.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[8][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[8][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[8][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[8][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[8][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[8][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[8][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[8][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[8][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[8][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[8][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[8][playerid], 1);

Inventory[9][playerid] = CreatePlayerTextDraw(playerid,526.000000, 279.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[9][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[9][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[9][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[9][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[9][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[9][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[9][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[9][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[9][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[9][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[9][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[9][playerid], 1);

Inventory[10][playerid] = CreatePlayerTextDraw(playerid,554.000000, 279.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[10][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[10][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[10][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[10][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[10][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[10][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[10][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[10][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[10][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[10][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[10][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[10][playerid], 1);

Inventory[11][playerid] = CreatePlayerTextDraw(playerid,582.000000, 279.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[11][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[11][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[11][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[11][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[11][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[11][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[11][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[11][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[11][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[11][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[11][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[11][playerid], 1);

Inventory[12][playerid] = CreatePlayerTextDraw(playerid,610.000000, 279.000000, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[12][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[12][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[12][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[12][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[12][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[12][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[12][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[12][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[12][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[12][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[12][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[12][playerid], 1);

Inventory[13][playerid] = CreatePlayerTextDraw(playerid,470.000000, 312.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[13][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[13][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[13][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[13][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[13][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[13][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[13][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[13][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[13][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[13][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[13][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[13][playerid], 1);

Inventory[14][playerid] = CreatePlayerTextDraw(playerid,498.000000, 312.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[14][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[14][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[14][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[14][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[14][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[14][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[14][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[14][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[14][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[14][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[14][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[14][playerid], 1);

Inventory[15][playerid] = CreatePlayerTextDraw(playerid,526.000000, 312.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[15][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[15][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[15][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[15][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[15][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[15][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[15][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[15][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[15][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[15][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[15][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[15][playerid], 1);

Inventory[16][playerid] = CreatePlayerTextDraw(playerid,554.000000, 312.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[16][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[16][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[16][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[16][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[16][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[16][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[16][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[16][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[16][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[16][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[16][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[16][playerid], 1);

Inventory[17][playerid] = CreatePlayerTextDraw(playerid,582.000000, 312.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[17][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[17][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[17][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[17][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[17][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[17][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[17][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[17][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[17][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[17][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[17][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[17][playerid], 1);

Inventory[18][playerid] = CreatePlayerTextDraw(playerid,610.000000, 312.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[18][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[18][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[18][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[18][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[18][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[18][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[18][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[18][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[18][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[18][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[18][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[18][playerid], 1);

Inventory[19][playerid] = CreatePlayerTextDraw(playerid,470.000000, 345.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[19][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[19][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[19][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[19][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[19][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[19][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[19][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[19][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[19][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[19][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[19][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[19][playerid], 1);

Inventory[20][playerid] = CreatePlayerTextDraw(playerid,498.000000, 345.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[20][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[20][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[20][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[20][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[20][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[20][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[20][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[20][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[20][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[20][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[20][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[20][playerid], 1);

Inventory[21][playerid] = CreatePlayerTextDraw(playerid,526.000000, 345.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[21][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[21][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[21][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[21][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[21][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[21][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[21][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[21][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[21][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[21][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[21][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[21][playerid], 1);

Inventory[22][playerid] = CreatePlayerTextDraw(playerid,554.000000, 345.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[22][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[22][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[22][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[22][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[22][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[22][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[22][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[22][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[22][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[22][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[22][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[22][playerid], 1);

Inventory[23][playerid] = CreatePlayerTextDraw(playerid,582.000000, 345.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[23][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[23][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[23][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[23][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[23][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[23][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[23][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[23][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[23][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[23][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[23][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[23][playerid], 1);

Inventory[24][playerid] = CreatePlayerTextDraw(playerid,610.000000, 345.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[24][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[24][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[24][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[24][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[24][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[24][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[24][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[24][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[24][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[24][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[24][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[24][playerid], 1);

Inventory[25][playerid] = CreatePlayerTextDraw(playerid,470.000000, 378.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[25][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[25][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[25][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[25][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[25][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[25][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[25][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[25][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[25][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[25][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[25][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[25][playerid], 1);

Inventory[26][playerid] = CreatePlayerTextDraw(playerid,498.000000, 378.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[26][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[26][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[26][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[26][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[26][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[26][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[26][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[26][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[26][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[26][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[26][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[26][playerid], 1);

Inventory[27][playerid] = CreatePlayerTextDraw(playerid,526.000000, 378.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[27][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[27][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[27][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[27][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[27][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[27][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[27][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[27][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[27][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[27][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[27][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[27][playerid], 1);

Inventory[28][playerid] = CreatePlayerTextDraw(playerid,554.000000, 378.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[28][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[28][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[28][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[28][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[28][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[28][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[28][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[28][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[28][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[28][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[28][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[28][playerid], 1);

Inventory[29][playerid] = CreatePlayerTextDraw(playerid,582.000000, 378.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[29][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[29][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[29][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[29][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[29][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[29][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[29][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[29][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[29][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[29][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[29][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[29][playerid], 1);

Inventory[30][playerid] = CreatePlayerTextDraw(playerid,610.000000, 378.700012, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[30][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[30][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[30][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[30][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[30][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[30][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[30][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[30][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[30][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[30][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[30][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[30][playerid], 1);

Inventory[31][playerid] = CreatePlayerTextDraw(playerid,470.000000, 412.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[31][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[31][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[31][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[31][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[31][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[31][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[31][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[31][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[31][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[31][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[31][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[31][playerid], 1);

Inventory[32][playerid] = CreatePlayerTextDraw(playerid,498.000000, 412.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[32][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[32][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[32][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[32][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[32][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[32][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[32][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[32][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[32][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[32][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[32][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[32][playerid], 1);

Inventory[33][playerid] = CreatePlayerTextDraw(playerid,526.000000, 412.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[33][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[33][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[33][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[33][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[33][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[33][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[33][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[33][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[33][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[33][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[33][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[33][playerid], 1);

Inventory[34][playerid] = CreatePlayerTextDraw(playerid,554.000000, 412.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[34][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[34][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[34][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[34][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[34][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[34][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[34][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[34][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[34][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[34][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[34][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[34][playerid], 1);

Inventory[35][playerid] = CreatePlayerTextDraw(playerid,582.000000, 412.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[35][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[35][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[35][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[35][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[35][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[35][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[35][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[35][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[35][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[35][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[35][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[35][playerid], 1);

Inventory[36][playerid] = CreatePlayerTextDraw(playerid,610.000000, 412.299987, "slot");
PlayerTextDrawBackgroundColor(playerid,Inventory[36][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[36][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[36][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[36][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[36][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[36][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[36][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[36][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[36][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[36][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[36][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[36][playerid], 1);

Inventory[37][playerid] = CreatePlayerTextDraw(playerid,86.500000, 246.000000, "_");
PlayerTextDrawAlignment(playerid,Inventory[37][playerid], 2);
PlayerTextDrawBackgroundColor(playerid,Inventory[37][playerid], 255);
PlayerTextDrawFont(playerid,Inventory[37][playerid], 1);
PlayerTextDrawLetterSize(playerid,Inventory[37][playerid], 0.500000, 22.000001);
PlayerTextDrawColor(playerid,Inventory[37][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[37][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[37][playerid], 1);
PlayerTextDrawSetShadow(playerid,Inventory[37][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[37][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[37][playerid], 80);
PlayerTextDrawTextSize(playerid,Inventory[37][playerid], 0.000000, -175.000000);
PlayerTextDrawSetSelectable(playerid,Inventory[37][playerid], 0);

Inventory[38][playerid] = CreatePlayerTextDraw(playerid,143.000000, 412.299987, "slotGUN");
PlayerTextDrawBackgroundColor(playerid,Inventory[38][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[38][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[38][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[38][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[38][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[38][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[38][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[38][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[38][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[38][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[38][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[38][playerid], 1);

Inventory[39][playerid] = CreatePlayerTextDraw(playerid,115.000000, 412.299987, "slotGUN");
PlayerTextDrawBackgroundColor(playerid,Inventory[39][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[39][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[39][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[39][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[39][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[39][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[39][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[39][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[39][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[39][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[39][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[39][playerid], 1);

Inventory[40][playerid] = CreatePlayerTextDraw(playerid,87.000000, 412.299987, "slotGUN");
PlayerTextDrawBackgroundColor(playerid,Inventory[40][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[40][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[40][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[40][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[40][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[40][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[40][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[40][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[40][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[40][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[40][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[40][playerid], 1);

Inventory[41][playerid] = CreatePlayerTextDraw(playerid,59.000000, 412.299987, "slotGUN");
PlayerTextDrawBackgroundColor(playerid,Inventory[41][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[41][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[41][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[41][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[41][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[41][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[41][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[41][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[41][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[41][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[41][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[41][playerid], 1);

Inventory[42][playerid] = CreatePlayerTextDraw(playerid,31.000000, 412.299987, "slotGUN");
PlayerTextDrawBackgroundColor(playerid,Inventory[42][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[42][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[42][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[42][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[42][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[42][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[42][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[42][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[42][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[42][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[42][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[42][playerid], 1);

Inventory[43][playerid] = CreatePlayerTextDraw(playerid,3.000000, 412.299987, "slotGUN");
PlayerTextDrawBackgroundColor(playerid,Inventory[43][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[43][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[43][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[43][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[43][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[43][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[43][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[43][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[43][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[43][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[43][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[43][playerid], 1);

Inventory[44][playerid] = CreatePlayerTextDraw(playerid,3.000000, 246.299987, "BRONYA");
PlayerTextDrawBackgroundColor(playerid,Inventory[44][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[44][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[44][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[44][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[44][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[44][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[44][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[44][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[44][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[44][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[44][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[44][playerid], 1);

Inventory[45][playerid] = CreatePlayerTextDraw(playerid,143.000000, 246.299987, "ODEJDA");
PlayerTextDrawBackgroundColor(playerid,Inventory[45][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[45][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[45][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[45][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[45][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[45][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[45][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[45][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[45][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[45][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[45][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[45][playerid], 1);

Inventory[46][playerid] = CreatePlayerTextDraw(playerid,319.500000, 412.000000, "__");
PlayerTextDrawAlignment(playerid,Inventory[46][playerid], 2);
PlayerTextDrawBackgroundColor(playerid,Inventory[46][playerid], 255);
PlayerTextDrawFont(playerid,Inventory[46][playerid], 1);
PlayerTextDrawLetterSize(playerid,Inventory[46][playerid], 0.500000, 3.599998);
PlayerTextDrawColor(playerid,Inventory[46][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[46][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[46][playerid], 1);
PlayerTextDrawSetShadow(playerid,Inventory[46][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[46][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[46][playerid], 80);
PlayerTextDrawTextSize(playerid,Inventory[46][playerid], 171.000000, -184.000000);
PlayerTextDrawSetSelectable(playerid,Inventory[46][playerid], 0);

Inventory[47][playerid] = CreatePlayerTextDraw(playerid,231.000000, 412.000000, "bistriislot");
PlayerTextDrawBackgroundColor(playerid,Inventory[47][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[47][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[47][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[47][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[47][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[47][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[47][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[47][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[47][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[47][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[47][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[47][playerid], 1);

Inventory[48][playerid] = CreatePlayerTextDraw(playerid,261.000000, 412.000000, "bistriislot");
PlayerTextDrawBackgroundColor(playerid,Inventory[48][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[48][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[48][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[48][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[48][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[48][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[48][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[48][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[48][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[48][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[48][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[48][playerid], 1);

Inventory[49][playerid] = CreatePlayerTextDraw(playerid,291.000000, 412.000000, "bistriislot");
PlayerTextDrawBackgroundColor(playerid,Inventory[49][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[49][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[49][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[49][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[49][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[49][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[49][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[49][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[49][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[49][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[49][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[49][playerid], 1);

Inventory[50][playerid] = CreatePlayerTextDraw(playerid,321.000000, 412.000000, "bistriislot");
PlayerTextDrawBackgroundColor(playerid,Inventory[50][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[50][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[50][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[50][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[50][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[50][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[50][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[50][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[50][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[50][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[50][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[50][playerid], 1);

Inventory[51][playerid] = CreatePlayerTextDraw(playerid,351.000000, 412.000000, "bistriislot");
PlayerTextDrawBackgroundColor(playerid,Inventory[51][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[51][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[51][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[51][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[51][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[51][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[51][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[51][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[51][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[51][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[51][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[51][playerid], 1);

Inventory[52][playerid] = CreatePlayerTextDraw(playerid,380.950012, 412.000000, "bistriislot");
PlayerTextDrawBackgroundColor(playerid,Inventory[52][playerid], -86);
PlayerTextDrawFont(playerid,Inventory[52][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[52][playerid], 0.500000, 1.000000);
PlayerTextDrawColor(playerid,Inventory[52][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[52][playerid], 0);
PlayerTextDrawSetProportional(playerid,Inventory[52][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[52][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[52][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[52][playerid], 27.000000, 32.000000);
PlayerTextDrawSetPreviewModel(playerid, Inventory[52][playerid], 19461);
PlayerTextDrawSetPreviewRot(playerid, Inventory[52][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
PlayerTextDrawSetSelectable(playerid,Inventory[52][playerid], 1);

Inventory[53][playerid] = CreatePlayerTextDraw(playerid,35.200000, 246.500000, "skin");
PlayerTextDrawBackgroundColor(playerid,Inventory[53][playerid], 0xFFFFFFAA);
PlayerTextDrawFont(playerid,Inventory[53][playerid], 5);
PlayerTextDrawLetterSize(playerid,Inventory[53][playerid], 1.009999, 1.000000);
PlayerTextDrawColor(playerid,Inventory[53][playerid], -1);
PlayerTextDrawSetOutline(playerid,Inventory[53][playerid], 1);
PlayerTextDrawSetProportional(playerid,Inventory[53][playerid], 1);
PlayerTextDrawSetShadow(playerid,Inventory[53][playerid], 1);
PlayerTextDrawUseBox(playerid,Inventory[53][playerid], 1);
PlayerTextDrawBoxColor(playerid,Inventory[53][playerid], 0x00000000);
PlayerTextDrawTextSize(playerid,Inventory[53][playerid], 103.000000, 163.000000);
PlayerTextDrawSetSelectable(playerid,Inventory[53][playerid], 1);
return 1;
}

public OnPlayerRequestClass(playerid,classid)
{
	LoadInventory(playerid);
    return 1;
}

public OnPlayerDisconnect(playerid,reason)
{
    for(new i; i < 55; i++) PlayerTextDrawHide(playerid,Inventory[i][playerid]);
    SaveInventory(playerid);
	return 1;
}

stock OpenInventory(playerid)
{
    PlayerTextDrawSetPreviewModel(playerid,Inventory[53][playerid], GetPlayerSkin(playerid));
    for(new i; i < 52; i++)
	{
        if(InventoryPlayer[playerid][invSlot][i] == 0) PlayerTextDrawSetPreviewModel(playerid,Inventory[i + 1][playerid], 19461),PlayerTextDrawSetPreviewRot(playerid, Inventory[i + 1][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
        else PlayerTextDrawSetPreviewModel(playerid,Inventory[i + 1][playerid], Items_All[InventoryPlayer[playerid][invSlot][i]][invObject]),PlayerTextDrawSetPreviewRot(playerid, Inventory[i + 1][playerid], -16.000000, -20.000000, -55.000000, 1.100000);
	}
	for(new i; i < 54; i++) PlayerTextDrawShow(playerid,Inventory[i][playerid]);
	for(new i; i < 9; i++) TextDrawShowForPlayer(playerid,Button[i]);
	return 1;
}

stock DropInventory(playerid)
{
    for(new i = 0; i < sizeof(ObjectInv); i++)
    {
		new Float:x,Float:y,Float:z;
		GetPlayerPos(playerid,x,y,z);
	    ObjectInv[i][obiDrop][0] = InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1];
	    ObjectInv[i][obiDrop][1] = InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1];
	    ObjectInv[i][obiDropPos][0] = x;
	    ObjectInv[i][obiDropPos][1] = y;
	    ObjectInv[i][obiDropPos][2] = z;
	    ObjectInv[i][obiObject] = CreateObject(Items_All[InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1]][invObject], ObjectInv[i][obiDropPos][0], ObjectInv[i][obiDropPos][1], ObjectInv[i][obiDropPos][2]-1, 80.0, 0.0, 0.0);
	    InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] = 0;
        InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] = 0;
        SetPVarInt(playerid,"SelectSlot",0);
        SetPVarInt(playerid,"ChangeSlot",0);
		OpenInventory(playerid);
	    return 1;
	}
	return 1;
}

stock ObjInventory(playerid)
{
    if(GetPVarInt(playerid,"ChangeSlot") == GetPVarInt(playerid,"SelectSlot")) return SetPVarInt(playerid,"ChangeSlot",0);
	if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] != 0 && InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] != InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"ChangeSlot") - 1]) return SetPVarInt(playerid,"ChangeSlot",0);
    if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] == InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"ChangeSlot") - 1])
	{
        InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"ChangeSlot") - 1] = 0;
        InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] += InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"ChangeSlot") - 1];
        InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"ChangeSlot") - 1] = 0;
    }
	if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] == 0)
	{
        InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] = InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"ChangeSlot") - 1];
        InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"SelectSlot") - 1] = InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"ChangeSlot") - 1];
        InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"ChangeSlot") - 1] = 0;
        InventoryPlayer[playerid][invKol][GetPVarInt(playerid,"ChangeSlot") - 1] = 0;
    }
	return 1;
}

stock UpdateInventory(playerid)
{
    if(GetPVarInt(playerid,"ChangeSlot") == GetPVarInt(playerid,"SelectSlot")) return SetPVarInt(playerid,"ChangeSlot",0);
	if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] != 0 && InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"SelectSlot") - 1] != InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"ChangeSlot") - 1]) return SetPVarInt(playerid,"ChangeSlot",0);
    if(InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"ChangeSlot") - 1] != 0)
	{
	    PlayerTextDrawSetPreviewModel(playerid,Inventory[GetPVarInt(playerid,"ChangeSlot")][playerid], 19461),PlayerTextDrawSetPreviewRot(playerid, Inventory[GetPVarInt(playerid,"ChangeSlot")][playerid], 0.000000, 0.000000, 90.000000, 0.100000);
	    PlayerTextDrawSetPreviewModel(playerid,Inventory[GetPVarInt(playerid,"SelectSlot")][playerid], Items_All[InventoryPlayer[playerid][invSlot][GetPVarInt(playerid,"ChangeSlot") - 1]][invObject]),PlayerTextDrawSetPreviewRot(playerid, Inventory[GetPVarInt(playerid,"SelectSlot")][playerid], -16.000000, -20.000000, -55.000000, 1.100000);
	    PlayerTextDrawShow(playerid,Inventory[GetPVarInt(playerid,"ChangeSlot")][playerid]);
	    PlayerTextDrawShow(playerid,Inventory[GetPVarInt(playerid,"SelectSlot")][playerid]);
	}
	return 1;
}

stock Name(i) { new pl[24]; GetPlayerName(i, pl, 24); return pl; }

stock LoadInventory(playerid)
{
    new str[100];
	format(str,sizeof(str),"SELECT * FROM `inventory` WHERE `Name`='%s' LIMIT 1",Name(playerid));
	s_res = db_query(s_db, str);
	if(db_num_rows(s_res) != 0)
	{
		for(new x; x != MAX_ITEMS; x++)
        {
            new str1[100],str2[100],buffer[32];
            format(str1,100,"Inv%d",x);
            format(str2,100,"InvKol%d",x);
            db_get_field_assoc(s_res,str1,buffer,32), InventoryPlayer[playerid][invSlot][x] = strval(buffer);
		    db_get_field_assoc(s_res,str2,buffer,32), InventoryPlayer[playerid][invKol][x] = strval(buffer);
        }
	}
	else
	{
	    format(str,sizeof(str),"INSERT INTO `inventory` (`Name`) VALUES ('%s')",Name(playerid));
	    db_query(s_db, str);
	    for(new x; x != MAX_ITEMS; x++)
        {
            InventoryPlayer[playerid][invSlot][x] = 0;
		    InventoryPlayer[playerid][invKol][x] = 0;
        }
        SaveInventory(playerid);
        LoadInventory(playerid);
	}
	db_free_result(s_res);
	return 1;
}

stock SaveInventory(playerid)
{
	new str[500];
	for(new x; x != MAX_ITEMS; x++)
    {
        format(str,sizeof(str),"UPDATE `inventory` SET Inv%d = %d WHERE `Name` = '%s'",x,InventoryPlayer[playerid][invSlot][x],Name(playerid));
 	    db_query(s_db, str);
 	    format(str,sizeof(str),"UPDATE `inventory` SET InvKol%d = %d WHERE `Name` = '%s'",x,InventoryPlayer[playerid][invKol][x],Name(playerid));
 	    db_query(s_db, str);
 	}
	return 1;
}

stock GiveInventory(playerid, item, amount)
{
	for(new k=0; k < 37; k++)
	{
		if(InventoryPlayer[playerid][invSlot][k] == 0)
		{
			InventoryPlayer[playerid][invSlot][k] = item;
			InventoryPlayer[playerid][invKol][k] = amount;
			return true;
		}
	}
	return false;
}
